// Version 0.4
// Last Update: 10/08/2000
// Used by ClusterManager

package Alkindi.Services.InternalData;

import java.util.*;
import Alkindi.Data.Product;

/* 
$Header: VMeans.java, 20, 4/26/01 2:37:00 PM, Schwartz, Joe$
$Log: 
 20   Alkindi Development1.19        4/26/01 2:37:00 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 19   Alkindi Development1.18        4/26/01 1:46:09 PM   Schwartz, Joe   Moved
      to new package.
 18   Alkindi Development1.17        2/14/01 6:22:17 PM   Schwartz, Joe  
      Changed logging to use StringBuffer instead of Strings. Change to match
      new RatingSpacePoint and SparseRatingsArray classes.
 17   Alkindi Development1.16        2/13/01 5:54:46 PM   Schwartz, Joe  
      Changed to account for new SparseRatingsArray class, used for base class
      of RatingSpacePoint.
 16   Alkindi Development1.15        1/26/01 5:48:31 PM   Schwartz, Joe  
      Improving efficiency.
 15   Alkindi Development1.14        1/22/01 1:46:13 PM   Schwartz, Joe  
      Converted into subclass of RatingSpacePoint.
 14   Alkindi Development1.13        1/21/01 4:40:11 PM   Schwartz, Joe  
      orrected class definition to include Cloneable interface. Eliminated
      constructors from clone() body.
 13   Alkindi Development1.12        12/28/00 1:07:29 PM  Schwartz, Joe   Added
      Version Control header info.
 12   Alkindi Development1.11        12/26/00 6:57:18 PM  Schwartz, Joe   
 11   Alkindi Development1.10        12/21/00 2:24:46 PM  Schwartz, Joe   Made
      clone() more rigorous.
 10   Alkindi Development1.9         12/18/00 12:06:26 PM Schwartz, Joe   Moved
      from (public) BusinessDataTypes package.
 9    Alkindi Development1.8         12/15/00 6:16:52 PM  Schwartz, Joe  
      Changed internal storage from arrays to hash of Products/Doubles.
 8    Alkindi Development1.7         12/3/00 5:28:01 PM   Schwartz, Joe   
 7    Alkindi Development1.6         12/2/00 2:57:24 PM   Schwartz, Joe   
 6    Alkindi Development1.5         12/2/00 1:02:14 PM   Schwartz, Joe   
 5    Alkindi Development1.4         11/8/00 2:59:04 PM   Schwartz, Joe   
 4    Alkindi Development1.3         10/22/00 10:38:48 AM Schwartz, Joe  
      AppianDelivery 10.20.00
 3    Alkindi Development1.2         10/22/00 10:33:57 AM Schwartz, Joe   
 2    Alkindi Development1.1         10/17/00 2:16:36 PM  Schwartz, Joe  
      Delivery 10.16.00
 1    Alkindi Development1.0         10/7/00 4:26:04 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * This represents a Vector of mean evaluations; it is the point in ratings space that represents the center of a UserCluster.
 */
public class VMeans extends RatingSpacePoint implements Cloneable 
{
	
	public VMeans() 
	{
	}
	
	/**
	 * Outputs a string representation of the internal data for debugging purposes.
	 * @return String
	 * @roseuid 3A29805401C5
	 */
	public String dump() 
	{
		sort();
		StringBuffer dumpBuf = new StringBuffer("VMeans Dump:\n");
		dumpBuf.append("Product/Means follow:\n");
		int numElems = size();
		
		if (numElems == 0) {
			dumpBuf.append("--> THIS VMEANS IS NULL\n");
			return dumpBuf.toString();
		}
		//	Set up number formatting for reasonable output.
		//
		java.text.NumberFormat numFormat = java.text.NumberFormat.getInstance();
		numFormat.setMinimumFractionDigits(4);
		numFormat.setMaximumFractionDigits(4);

		for (int idx = 0; idx < numElems; idx ++ ) {
			SparseRatingsArray.ProductRating pr = (ProductRating)internalList.get(idx);
			dumpBuf.append(pr.productID);
			dumpBuf.append(": ");
			dumpBuf.append(numFormat.format(pr.evaluation));
			dumpBuf.append("\n");
		}
		dumpBuf.append("done dumping VMeans item.\n");
		return dumpBuf.toString();
	}
	
	/**
	 * @roseuid 3A3A52960280
	 */
	public VMeans(final int capacity) 
	{
		super(capacity);
	}
}
